/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.engine;

import javax.microedition.lcdui.Canvas;

public class KeyCode {
    private static KeyCode _instance;
    private static Canvas _canvas;
    private static int _curKey;
    private static int[] _keyBuff;
    private static int _keyRear;
    private static final int[][] N97_TOUCH_DATA;
    private static final int[][] N97_TOUCH_ACTION;
    public static int cur_Touch_key;

    public KeyCode(Canvas canvas) {
        _canvas = canvas;
    }

    public static KeyCode instance(Canvas canvas) {
        if (_instance == null) {
            _instance = new KeyCode(canvas);
        }
        return _instance;
    }

    public static final void resetKeyBuff() {
        _keyRear = 0;
        int n = 0;
        while (n < 4) {
            KeyCode._keyBuff[n] = 0;
            ++n;
        }
    }

    private final void produceKey(int n) {
        KeyCode._keyBuff[KeyCode._keyRear] = n;
        if (++_keyRear >= 4) {
            _keyRear = 0;
        }
    }

    public static final int consumeKey(int n) {
        int n2 = _keyBuff[n];
        return n2;
    }

    public final void keyPressed(int n) {
        cur_Touch_key = _curKey = this.getTranslateKeyCode(n);
        this.produceKey(_curKey);
    }

    public final void keyReleased(int n) {
        cur_Touch_key = _curKey = 0;
    }

    public static final int getCurKey() {
        return _curKey;
    }

    public static final void resetCurKey() {
        _curKey = 0;
    }

    private final int getTranslateKeyCode(int n) {
        switch (0) {
            case 0: 
            case 2: 
            case 3: {
                return this.translateKeyCodeForNokia(n);
            }
            case 1: 
            case 5: {
                return this.translateKeyCodeForMoto(n);
            }
            case 4: {
                return this.translateKeyCodeForE2(n);
            }
            case 6: {
                return this.translateKeyCodeForE62(n);
            }
        }
        return 0;
    }

    private final int translateKeyCodeForNokia(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 4;
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                n2 = 8;
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                n2 = 1;
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                n2 = 2;
                break;
            }
            case -5: 
            case 53: {
                n2 = 16;
                break;
            }
            case 49: {
                n2 = 1024;
                break;
            }
            case 51: {
                n2 = 4096;
                break;
            }
            case 55: {
                n2 = 32768;
                break;
            }
            case 57: {
                n2 = 131072;
                break;
            }
            case 35: {
                n2 = 256;
                break;
            }
            case 42: {
                n2 = 128;
                break;
            }
            case -6: {
                n2 = 262144;
                break;
            }
            case -7: {
                n2 = 524288;
                break;
            }
            case 48: {
                n2 = 512;
            }
        }
        return n2;
    }

    private final int translateKeyCodeForMoto(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 4;
                break;
            }
            case -6: 
            case 6: 
            case 56: {
                n2 = 8;
                break;
            }
            case -2: 
            case 2: 
            case 52: {
                n2 = 1;
                break;
            }
            case -5: 
            case 5: 
            case 54: {
                n2 = 2;
                break;
            }
            case -20: 
            case 20: 
            case 53: {
                n2 = 16;
                break;
            }
            case 49: {
                n2 = 1024;
                break;
            }
            case 51: {
                n2 = 4096;
                break;
            }
            case 55: {
                n2 = 32768;
                break;
            }
            case 57: {
                n2 = 131072;
                break;
            }
            case 35: {
                n2 = 256;
                break;
            }
            case 42: {
                n2 = 128;
                break;
            }
            case -21: 
            case 21: {
                n2 = 262144;
                break;
            }
            case -22: 
            case 22: {
                n2 = 524288;
                break;
            }
            case 48: {
                n2 = 48;
            }
        }
        return n2;
    }

    private final int translateKeyCodeForE2(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 4;
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                n2 = 8;
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                n2 = 1;
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                n2 = 2;
                break;
            }
            case -5: 
            case 20: 
            case 53: {
                n2 = 16;
                break;
            }
            case 49: {
                n2 = 1024;
                break;
            }
            case 51: {
                n2 = 4096;
                break;
            }
            case 55: {
                n2 = 32768;
                break;
            }
            case 57: {
                n2 = 131072;
                break;
            }
            case 35: {
                n2 = 256;
                break;
            }
            case 42: {
                n2 = 128;
                break;
            }
            case -21: 
            case -6: 
            case 21: {
                n2 = 262144;
                break;
            }
            case -22: 
            case -8: 
            case -7: 
            case 22: {
                n2 = 524288;
                break;
            }
            case 48: {
                n2 = 512;
            }
        }
        return n2;
    }

    private final int translateKeyCodeForE62(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 116: {
                n2 = 4;
                break;
            }
            case -2: 
            case 98: {
                n2 = 8;
                break;
            }
            case -3: 
            case 102: {
                n2 = 1;
                break;
            }
            case -4: 
            case 104: {
                n2 = 2;
                break;
            }
            case -5: 
            case 103: {
                n2 = 16;
                break;
            }
            case 114: {
                n2 = 1024;
                break;
            }
            case 121: {
                n2 = 4096;
                break;
            }
            case 118: {
                n2 = 32768;
                break;
            }
            case 110: {
                n2 = 131072;
                break;
            }
            case 109: {
                n2 = 512;
                break;
            }
            case 106: 
            case 256: {
                n2 = 256;
                break;
            }
            case 117: 
            case 128: {
                n2 = 128;
                break;
            }
            case -6: {
                n2 = 262144;
                break;
            }
            case -7: {
                n2 = 524288;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static final boolean isPressConfirmKey() {
        return KeyCode.isPressFireKey() || KeyCode.isPressConfirmSoftKey();
    }

    public static final boolean isPressCancelKey() {
        return KeyCode.isPressCancelSoftKey();
    }

    public static boolean isPressCancelSoftKey() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return _curKey == 524288;
            }
            case 1: {
                return _curKey == 262144;
            }
        }
        return false;
    }

    public static boolean isPressSystemCancelSoftKey() {
        switch (0) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return _curKey == 524288;
            }
            case 1: 
            case 2: {
                return _curKey == 262144;
            }
        }
        return false;
    }

    public static final boolean isPressFireKey() {
        return _curKey == 16;
    }

    public static final boolean isPressConfirmSoftKey() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return _curKey == 262144;
            }
            case 1: {
                return _curKey == 524288;
            }
        }
        return false;
    }

    public static final boolean isPressSystemConfirmSoftKey() {
        switch (0) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return _curKey == 262144;
            }
            case 1: 
            case 2: {
                return _curKey == 524288;
            }
        }
        return false;
    }

    public static final int getConfirmPos() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public static final boolean standardKeyCode() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    public static final boolean standardSystemKeyCode() {
        switch (0) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    public final void initTouchScreen() {
    }

    public void pointerPressed(int n, int n2) {
    }

    public void pointerReleased(int n, int n2) {
    }

    static {
        _keyBuff = new int[4];
        _keyRear = 0;
        N97_TOUCH_DATA = new int[][]{{0, 320, 76, 25, 1024}, {82, 320, 76, 25, 4}, {164, 320, 76, 25, 4096}, {0, 347, 76, 25, 1}, {82, 347, 76, 25, 16}, {164, 347, 76, 25, 2}, {0, 374, 76, 25, 32768}, {82, 374, 76, 25, 8}, {164, 374, 76, 25, 131072}, {0, 401, 76, 25, 128}, {82, 401, 76, 25, 512}, {164, 401, 76, 25, 256}, {0, 295, 76, 25, 262144}, {164, 295, 76, 25, 524288}};
        N97_TOUCH_ACTION = new int[][]{{0, 12}, {1, 13}, {2, 14}, {3, 15}, {4, 16}, {5, 17}, {6, 18}, {7, 19}, {8, 20}, {9, 21}, {10, 22}, {11, 23}};
        cur_Touch_key = 0;
    }
}

